<?php
	
/*
	Question2Answer 1.4-dev (c) 2011, Gideon Greenspan

	http://www.question2answer.org/

	
	File: qa-include/qa-page-admin-points.php
	Version: 1.4-dev
	Date: 2011-04-04 09:06:42 GMT
	Description: Controller for admin page for user points


	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	More about this license: http://www.question2answer.org/license.php
*/

	if (!defined('QA_VERSION')) { // don't allow this page to be requested directly from browser
		header('Location: ../');
		exit;
	}

	require_once QA_INCLUDE_DIR.'qa-db-recalc.php';
	require_once QA_INCLUDE_DIR.'qa-db-points.php';
	require_once QA_INCLUDE_DIR.'qa-app-options.php';
	require_once QA_INCLUDE_DIR.'qa-app-admin.php';
	
	
//	Check admin privileges

	if (!qa_admin_check_privileges($qa_content))
		return $qa_content;


//	Process user actions

	$optionnames=qa_db_points_option_names();

	if (qa_clicked('doshowdefaults')) {
		$options=array();
		
		foreach ($optionnames as $optionname)
			$options[$optionname]=qa_default_option($optionname);
		
	} else {
		if (qa_clicked('docancel'))
			;

		elseif (qa_clicked('dosaverecalc')) {
			foreach ($optionnames as $optionname)
				qa_set_option($optionname, (int)qa_post_text('option_'.$optionname));
				
			if (!qa_post_text('has_js'))
				qa_redirect('admin/recalc', array('dorecalcpoints' => 1));
		}
	
		$options=qa_get_options($optionnames);
	}
	
	
//	Prepare content for theme

	$qa_content=qa_content_prepare();

	$qa_content['title']=qa_lang_html('admin/admin_title').' - '.qa_lang_html('admin/points_title');

	$qa_content['error']=qa_admin_page_error();

	$qa_content['form']=array(
		'tags' => 'METHOD="POST" ACTION="'.qa_self_html().'" NAME="points_form" onsubmit="document.forms.points_form.has_js.value=1; return true;"',
		
		'style' => 'wide',
		
		'buttons' => array(
			'saverecalc' => array(
				'tags' => 'NAME="dorecalcpoints" ID="dosaverecalc"', // name important for recalc logic
				'label' => qa_lang_html('admin/save_recalc_button'),
			),
		),
		
		'hidden' => array(
			'dosaverecalc' => '1',
			'has_js' => '0',
		),
	);

	
	if (qa_clicked('doshowdefaults')) {
		$qa_content['form']['ok']=qa_lang_html('admin/points_defaults_shown');
	
		$qa_content['form']['buttons']['cancel']=array(
			'tags' => 'NAME="docancel"',
			'label' => qa_lang_html('main/cancel_button'),
		);

	} else {
		if (qa_clicked('docancel'))
			;
		elseif (qa_clicked('dosaverecalc')) {
			$qa_content['form']['ok']='<SPAN ID="recalc_points_ok"></SPAN>';
			
			$qa_content['script_rel'][]='qa-content/jxs_compressed.js';
			$qa_content['script_rel'][]='qa-content/qa-admin.js?'.QA_VERSION;
			$qa_content['script_var']['qa_warning_recalc']=qa_lang('admin/stop_recalc_warning');
			
			$qa_content['script_onloads'][]=array(
				"qa_recalc_click(document.getElementById('dosaverecalc'), ".qa_js(qa_lang('admin/save_recalc_button')).", 'recalc_points_ok');"
			); // doesn't change button title since we haven't set up onClick handler anyway
		}
		
		$qa_content['form']['buttons']['showdefaults']=array(
			'tags' => 'NAME="doshowdefaults"',
			'label' => qa_lang_html('admin/show_defaults_button'),
		);
	}

	
	foreach ($optionnames as $optionname) {
		$optionfield=array(
			'label' => qa_lang_html('options/'.$optionname),
			'tags' => 'NAME="option_'.$optionname.'"',
			'value' => qa_html($options[$optionname]),
			'type' => 'number',
			'note' => qa_lang_html('admin/points'),
		);
		
		switch ($optionname) {
			case 'points_multiple':
				$prefix='&#215;';
				unset($optionfield['note']);
				break;
				
			case 'points_per_q_voted':
			case 'points_per_a_voted':
				$prefix='&#177;';
				break;
				
			case 'points_q_voted_max_gain':
			case 'points_a_voted_max_gain':
				$prefix='+';
				break;
			
			case 'points_q_voted_max_loss':
			case 'points_a_voted_max_loss':
				$prefix='&ndash;';
				break;
				
			case 'points_base':
				$prefix='+';
				break;
				
			default:
				$prefix='<SPAN STYLE="visibility:hidden;">+</SPAN>'; // for even alignment
				break;
		}
		
		$optionfield['prefix']='<SPAN STYLE="width:1em; display:inline-block; display:-moz-inline-stack;">'.$prefix.'</SPAN>';
		
		$qa_content['form']['fields'][$optionname]=$optionfield;
	}

	
	$qa_content['navigation']['sub']=qa_admin_sub_navigation();
	
	return $qa_content;


/*
	Omit PHP closing tag to help avoid accidental output
*/