<?php

/*
	Question2Answer 1.4-dev (c) 2011, Gideon Greenspan

	http://www.question2answer.org/

	
	File: qa-plugin/mouseover-layer/qa-mouseover-admin-form.php
	Version: 1.4-dev
	Date: 2011-04-04 09:06:42 GMT
	Description: Generic module class for mouseover layer plugin to provide admin form and default option


	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	More about this license: http://www.question2answer.org/license.php
*/

	class qa_mouseover_admin_form {
		
		function option_default($option)
		{
			if ($option=='mouseover_content_max_len')
				return 480;
		}
		
		function admin_form(&$qa_content)
		{
			$saved=false;
			
			if (qa_clicked('mouseover_save_button')) {
				qa_opt('mouseover_content_on', (int)qa_post_text('mouseover_content_on_field'));
				qa_opt('mouseover_content_max_len', (int)qa_post_text('mouseover_content_max_len_field'));
				$saved=true;
			}
			
			qa_checkbox_to_display($qa_content, array(
				'mouseover_content_max_len_display' => 'mouseover_content_on_field',
			));
			
			return array(
				'ok' => $saved ? 'Mouseover settings saved' : null,
				
				'fields' => array(
					array(
						'label' => 'Show content on mouseover in question lists',
						'type' => 'checkbox',
						'value' => qa_opt('mouseover_content_on'),
						'tags' => 'NAME="mouseover_content_on_field" ID="mouseover_content_on_field"',
					),
					
					array(
						'id' => 'mouseover_content_max_len_display',
						'label' => 'Maximum number of characters to show:',
						'type' => 'number',
						'value' => (int)qa_opt('mouseover_content_max_len'),
						'tags' => 'NAME="mouseover_content_max_len_field"',
					),
				),
				
				'buttons' => array(
					array(
						'label' => 'Save Changes',
						'tags' => 'NAME="mouseover_save_button"',
					),
				),
			);
		}
		
	};
	

/*
	Omit PHP closing tag to help avoid accidental output
*/