<?php
  /*
    Question2Answer 1.3.1 (c) 2011, Gideon Greenspan

    http://www.question2answer.org/

    
    File: qa-external-example/qa-external-categories.php
    Version: 1.3.1
    Date: 2011-03-03 12:56:28 GMT
    Description: Example of how to integrate with your own category database
    Author: Mlanie Gauthier

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    More about this license: http://www.question2answer.org/license.php
*/

/*
    ==============================================================================
    THIS FILE ALLOWS YOU TO INTEGRATE WITH AN EXISTING CATEGORY MANAGEMENT SYSTEM
    ==============================================================================

    It is used if QA_EXTERNAL_CATEGORIES is set to true in qa-config.php.
*/

function qa_get_mysql_category_column_type()
    {
/*
    ==========================================================================
          YOU MUST MODIFY THIS FUNCTION *BEFORE* QA CREATES ITS DATABASE
    ==========================================================================

    You should return the appropriate MySQL column type to use for the categoryid,
    for smooth integration with your existing categories. Allowed options are:
    
    SMALLINT, SMALLINT UNSIGNED, MEDIUMINT, MEDIUMINT UNSIGNED, INT, INT UNSIGNED,
    BIGINT, BIGINT UNSIGNED or VARCHAR(x) where x is the maximum length.
*/

    //    Set this before anything else

        return "INT UNSIGNED";

    /*
        Example 1 - suitable if:
        
        * You use textual category identifiers with a maximum length of 32

        return 'VARCHAR(32)';
    */
    
    /*
        Example 2 - suitable if:
        
        * You use unsigned numerical category identifiers in an INT UNSIGNED column
        
        return 'INT UNSIGNED';
    */
    }     
  
    
     function qa_get_categories() {
/*
    ==========================================================================
    YOU MUST MODIFY THIS FUNCTION, BUT CAN DO SO AFTER QA CREATES ITS DATABASE
    ==========================================================================

    You sould return an array containing the categories available with the following information:
        - categoryid: the id of the category.
        - title: the title (name) to use for this category.
        - tags:  The Category slug (URL fragment)
        - qcount: the question count for this category, 
                         may be empty if you set QA_EXTERNAL_CATEGORIES_USE_QCOUNT to false 
    
    Categories should be in the order you want to display them.
 
*/        
        $categoryinfo = array();   
        // Modify this to fecth your categories    
    /*     foreach ($categories as $categoryinfo) {
                   $categoryinfo[$i] = array(
                    'categoryid' => $i,
                    'title' => 'category '.$i,
                    'tags' => 'tag '.$i,
                    'qcount' => '',
               );
              
        }    */
        return $categoryinfo;
     }    
    
      
      function qa_get_categoryid_by_slug($categoryslug) {
/*
    ==========================================================================
    YOU MUST MODIFY THIS FUNCTION, BUT CAN DO SO AFTER QA CREATES ITS DATABASE
    ==========================================================================

    You should return the id of the category that uses the given URL fragment.
*/        
          return "";
          
      }
      
      
      function qa_ifcategory_qcount_update($categoryid) {
/*
    ==========================================================================
    YOU MAY MODIFY THIS FUNCTION, BUT CAN DO SO AFTER QA CREATES ITS DATABASE,
    IF YOU WISH TO CACHE THE NUMBER OF QUESTIONS BY CATEGORIES.
    ==========================================================================

    This is called each time a question is assigned or removed from a category.
*/              
      }
      

/*
    Omit PHP closing tag to help avoid accidental output
*/