<?php
 
/*
    Question2Answer 1.3.1 (c) 2011, Gideon Greenspan

    http://www.question2answer.org/

    
    File: qa-include/qa-app-categories.php
    Version: 1.3.1
    Date: 2011-02-01 12:56:28 GMT
    Description: Common functions for getting categories.
    Created on March 11, 2011 by Mlanie Gauthier 


    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    More about this license: http://www.question2answer.org/license.php
*/ 
    if (!defined('QA_VERSION')) { // don't allow this page to be requested directly from browser
        header('Location: ../');
        exit;
    }
    
    
    if (QA_EXTERNAL_CATEGORIES) {
        require_once QA_EXTERNAL_DIR.'qa-external-categories.php'; 
    } else {
        require_once QA_INCLUDE_DIR.'qa-db-selects.php';

         function qa_get_categories() { 
             /*
                Return an array containning ids of the categories id available with all the information.
                    - categoryid: The category id        
                    - title : The title (name) of the category
                    - tags : The Category slug (URL fragment) 
                    - position: The position where to disply this category (optional)
                    - qcount: The number of questions for this category.
            */  
            return qa_db_select_with_pending(qa_db_categories_selectspec())  ;
         }
      
        function qa_get_mysql_category_column_type()
        {
            return "SMALLINT UNSIGNED"; 
        }
        
       
        
        
        function qa_get_categoryid_by_slug($categoryslug) {
            return qa_db_select_with_pending(qa_db_slug_to_category_id_selectspec($categoryslug));
        }
        
         function qa_ifcategory_qcount_update($categoryid) {
             require_once QA_INCLUDE_DIR.'qa-db-post-create.php'; 
             qa_db_ifcategory_qcount_update($categoryid);
         }
    
        
    
    } // END ELSE


/*
    Omit PHP closing tag to help avoid accidental output
*/
    
